/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;
import java.util.Vector;

import djbuch.kapitel_06.GC;
import djbuch.kapitel_13.DJAgentContext;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class NewsletterStart implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de:63148"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		NewsletterStart nlStart = new NewsletterStart ();
		NotesThread nt = new NotesThread (nlStart);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		DJAgentContext agentContext = null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			agentContext = getTestAgentContext(session);
			Newsletter nl = new Newsletter (agentContext);
			int count = nl.send();
			System.out.println("Anzahl der versendeten NL: "
				+ (count == Newsletter.SEND_ERROR 
					? "FEHLER!" 
					: "" + count));
		} catch (NotesException e) {
			System.out.println ("id = " + e.id);
			e.printStackTrace();
		} finally {
			GC.recycle (agentContext);
			GC.recycle(session);
		}
	}
	
	private static DJAgentContext getTestAgentContext(Session session) throws NotesException {
		Database contextDB = null;
		NLDocument nlDoc = null;
		contextDB = session.getDatabase("Java/DJBUCH","djbuch/djbuch.nsf");
		nlDoc = NLDocument.getInstance(contextDB);
		nlDoc.setActive(true);
		nlDoc.setBody("Hallo, ich bin ein NL.");
		Vector rec=new Vector();
		rec.add ("ekert@bitsdontbyte.de");
		rec.add ("Administrator@www.djbuch.de");
		nlDoc.setRecipients(rec);
		nlDoc.setSubject("DJBuch Newsletter");
		nlDoc.save (true,false);
		return new DJAgentContext ("Anonymous",contextDB, nlDoc.getDoc());
	}
}
